/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.xml.builders;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.queries.spans.SpanOrQuery;
import org.apache.lucene.ars_nouveau.queries.spans.SpanQuery;
import org.apache.lucene.ars_nouveau.queries.spans.SpanTermQuery;
import org.apache.lucene.ars_nouveau.queryparser.xml.DOMUtils;
import org.apache.lucene.ars_nouveau.queryparser.xml.ParserException;
import org.apache.lucene.ars_nouveau.queryparser.xml.builders.SpanBuilderBase;
import org.w3c.dom.Element;

public class SpanOrTermsBuilder
extends SpanBuilderBase {
    private final Analyzer analyzer;

    public SpanOrTermsBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public SpanQuery getSpanQuery(Element e) throws ParserException {
        SpanOrQuery spanOrQuery;
        block9: {
            String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
            String value = DOMUtils.getNonBlankTextOrFail(e);
            ArrayList<SpanTermQuery> clausesList = new ArrayList<SpanTermQuery>();
            TokenStream ts = this.analyzer.tokenStream(fieldName, value);
            try {
                TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
                ts.reset();
                while (ts.incrementToken()) {
                    SpanTermQuery stq = new SpanTermQuery(new Term(fieldName, termAtt.getBytesRef()));
                    clausesList.add(stq);
                }
                ts.end();
                spanOrQuery = new SpanOrQuery(clausesList.toArray(new SpanQuery[clausesList.size()]));
                if (ts == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ts != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new ParserException("IOException parsing value:" + value, ioe);
                }
            }
            ts.close();
        }
        return spanOrQuery;
    }
}

